package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportClientVpnClientConfigurationRequest(
    clientVpnEndpointId: ClientVpnEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest = {
    import ExportClientVpnClientConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest
      .wrap(buildAwsValue())
}
object ExportClientVpnClientConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest =
      zio.aws.ec2.model
        .ExportClientVpnClientConfigurationRequest(clientVpnEndpointId)
    def clientVpnEndpointId: ClientVpnEndpointId
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ) extends zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ): zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
