package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticGpuHealth(
    status: Option[zio.aws.ec2.model.ElasticGpuStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticGpuHealth = {
    import ElasticGpuHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticGpuHealth
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ElasticGpuHealth.ReadOnly =
    zio.aws.ec2.model.ElasticGpuHealth.wrap(buildAwsValue())
}
object ElasticGpuHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticGpuHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticGpuHealth =
      zio.aws.ec2.model.ElasticGpuHealth(status.map(value => value))
    def status: Option[zio.aws.ec2.model.ElasticGpuStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.ElasticGpuStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuHealth
  ) extends zio.aws.ec2.model.ElasticGpuHealth.ReadOnly {
    override val status: Option[zio.aws.ec2.model.ElasticGpuStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.ElasticGpuStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuHealth
  ): zio.aws.ec2.model.ElasticGpuHealth.ReadOnly = new Wrapper(impl)
}
