package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  TransitGatewayAttachmentId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayMulticastDomainRequest(
    transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId] =
      None,
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    subnetIds: Option[Iterable[SubnetId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest = {
    import DisassociateTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        subnetIds.map(value => value)
      )
    def transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId]
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def subnetIds: Option[List[SubnetId]]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Option[TransitGatewayMulticastDomainId] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
