package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableSerialConsoleAccessResponse(
    serialConsoleAccessEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse = {
    import DisableSerialConsoleAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse
      .builder()
      .optionallyWith(
        serialConsoleAccessEnabled.map(value => value: java.lang.Boolean)
      )(_.serialConsoleAccessEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly =
    zio.aws.ec2.model.DisableSerialConsoleAccessResponse.wrap(buildAwsValue())
}
object DisableSerialConsoleAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableSerialConsoleAccessResponse =
      zio.aws.ec2.model.DisableSerialConsoleAccessResponse(
        serialConsoleAccessEnabled.map(value => value)
      )
    def serialConsoleAccessEnabled: Option[Boolean]
    def getSerialConsoleAccessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "serialConsoleAccessEnabled",
        serialConsoleAccessEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse
  ) extends zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly {
    override val serialConsoleAccessEnabled: Option[Boolean] = scala
      .Option(impl.serialConsoleAccessEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse
  ): zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly =
    new Wrapper(impl)
}
