package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServicesResponse(
    serviceNames: Option[Iterable[String]] = None,
    serviceDetails: Option[Iterable[zio.aws.ec2.model.ServiceDetail]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse = {
    import DescribeVpcEndpointServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse
      .builder()
      .optionallyWith(
        serviceNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.serviceNames)
      .optionallyWith(
        serviceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceDetails)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.wrap(buildAwsValue())
}
object DescribeVpcEndpointServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcEndpointServicesResponse =
      zio.aws.ec2.model.DescribeVpcEndpointServicesResponse(
        serviceNames.map(value => value),
        serviceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def serviceNames: Option[List[String]]
    def serviceDetails: Option[List[zio.aws.ec2.model.ServiceDetail.ReadOnly]]
    def nextToken: Option[String]
    def getServiceNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("serviceNames", serviceNames)
    def getServiceDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ServiceDetail.ReadOnly]] =
      AwsError.unwrapOptionField("serviceDetails", serviceDetails)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly {
    override val serviceNames: Option[List[String]] = scala
      .Option(impl.serviceNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceDetails
        : Option[List[zio.aws.ec2.model.ServiceDetail.ReadOnly]] = scala
      .Option(impl.serviceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ServiceDetail.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly =
    new Wrapper(impl)
}
