package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayConnectsResponse(
    transitGatewayConnects: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayConnect]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse = {
    import DescribeTransitGatewayConnectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse
      .builder()
      .optionallyWith(
        transitGatewayConnects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayConnects)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayConnectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse(
        transitGatewayConnects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayConnects
        : Option[List[zio.aws.ec2.model.TransitGatewayConnect.ReadOnly]]
    def nextToken: Option[String]
    def getTransitGatewayConnects: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayConnect.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayConnects",
      transitGatewayConnects
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly {
    override val transitGatewayConnects
        : Option[List[zio.aws.ec2.model.TransitGatewayConnect.ReadOnly]] = scala
      .Option(impl.transitGatewayConnects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayConnect.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly =
    new Wrapper(impl)
}
