package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  TrafficMirroringMaxResults,
  TrafficMirrorSessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorSessionsRequest(
    trafficMirrorSessionIds: Option[Iterable[TrafficMirrorSessionId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TrafficMirroringMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest = {
    import DescribeTrafficMirrorSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest
      .builder()
      .optionallyWith(
        trafficMirrorSessionIds.map(value =>
          value.map { item =>
            TrafficMirrorSessionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trafficMirrorSessionIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          TrafficMirroringMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest.wrap(buildAwsValue())
}
object DescribeTrafficMirrorSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest =
      zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest(
        trafficMirrorSessionIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trafficMirrorSessionIds: Option[List[TrafficMirrorSessionId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TrafficMirroringMaxResults]
    def nextToken: Option[NextToken]
    def getTrafficMirrorSessionIds
        : ZIO[Any, AwsError, List[TrafficMirrorSessionId]] = AwsError
      .unwrapOptionField("trafficMirrorSessionIds", trafficMirrorSessionIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TrafficMirroringMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest.ReadOnly {
    override val trafficMirrorSessionIds: Option[List[TrafficMirrorSessionId]] =
      scala
        .Option(impl.trafficMirrorSessionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrafficMirrorSessionId(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TrafficMirroringMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TrafficMirroringMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest
  ): zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest.ReadOnly =
    new Wrapper(impl)
}
