package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSpotDatafeedSubscriptionResponse(
    spotDatafeedSubscription: Option[
      zio.aws.ec2.model.SpotDatafeedSubscription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse = {
    import DescribeSpotDatafeedSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse
      .builder()
      .optionallyWith(
        spotDatafeedSubscription.map(value => value.buildAwsValue())
      )(_.spotDatafeedSubscription)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse
      .wrap(buildAwsValue())
}
object DescribeSpotDatafeedSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse =
      zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse(
        spotDatafeedSubscription.map(value => value.asEditable)
      )
    def spotDatafeedSubscription
        : Option[zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly]
    def getSpotDatafeedSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotDatafeedSubscription",
      spotDatafeedSubscription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse
  ) extends zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly {
    override val spotDatafeedSubscription
        : Option[zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly] = scala
      .Option(impl.spotDatafeedSubscription())
      .map(value => zio.aws.ec2.model.SpotDatafeedSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse
  ): zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
