package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeSecurityGroupsMaxResults,
  SecurityGroupName,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    groupIds: Option[Iterable[SecurityGroupId]] = None,
    groupNames: Option[Iterable[SecurityGroupName]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeSecurityGroupsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest = {
    import DescribeSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeSecurityGroupsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupsRequest.wrap(buildAwsValue())
}
object DescribeSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupsRequest =
      zio.aws.ec2.model.DescribeSecurityGroupsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupIds.map(value => value),
        groupNames.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def groupIds: Option[List[SecurityGroupId]]
    def groupNames: Option[List[SecurityGroupName]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeSecurityGroupsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
    def getGroupNames: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeSecurityGroupsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ) extends zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val groupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.groupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val groupNames: Option[List[SecurityGroupName]] = scala
      .Option(impl.groupNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupName(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeSecurityGroupsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeSecurityGroupsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ): zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
