package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsMaxResults,
  NetworkInsightsAccessScopeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAccessScopesRequest(
    networkInsightsAccessScopeIds: Option[
      Iterable[NetworkInsightsAccessScopeId]
    ] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[NetworkInsightsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest = {
    import DescribeNetworkInsightsAccessScopesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeIds.map(value =>
          value.map { item =>
            NetworkInsightsAccessScopeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsAccessScopeIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAccessScopesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest(
        networkInsightsAccessScopeIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeIds
        : Option[List[NetworkInsightsAccessScopeId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[NetworkInsightsMaxResults]
    def nextToken: Option[NextToken]
    def getNetworkInsightsAccessScopeIds
        : ZIO[Any, AwsError, List[NetworkInsightsAccessScopeId]] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeIds",
        networkInsightsAccessScopeIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest.ReadOnly {
    override val networkInsightsAccessScopeIds
        : Option[List[NetworkInsightsAccessScopeId]] = scala
      .Option(impl.networkInsightsAccessScopeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[NetworkInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest.ReadOnly =
    new Wrapper(impl)
}
