package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeLaunchTemplatesMaxResults,
  LaunchTemplateName,
  LaunchTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplatesRequest(
    launchTemplateIds: Option[Iterable[LaunchTemplateId]] = None,
    launchTemplateNames: Option[Iterable[LaunchTemplateName]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeLaunchTemplatesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest = {
    import DescribeLaunchTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
      .builder()
      .optionallyWith(
        launchTemplateIds.map(value =>
          value.map { item =>
            LaunchTemplateId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchTemplateIds)
      .optionallyWith(
        launchTemplateNames.map(value =>
          value.map { item =>
            LaunchTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchTemplateNames)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeLaunchTemplatesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplatesRequest.wrap(buildAwsValue())
}
object DescribeLaunchTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplatesRequest =
      zio.aws.ec2.model.DescribeLaunchTemplatesRequest(
        launchTemplateIds.map(value => value),
        launchTemplateNames.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def launchTemplateIds: Option[List[LaunchTemplateId]]
    def launchTemplateNames: Option[List[LaunchTemplateName]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeLaunchTemplatesMaxResults]
    def getLaunchTemplateIds: ZIO[Any, AwsError, List[LaunchTemplateId]] =
      AwsError.unwrapOptionField("launchTemplateIds", launchTemplateIds)
    def getLaunchTemplateNames: ZIO[Any, AwsError, List[LaunchTemplateName]] =
      AwsError.unwrapOptionField("launchTemplateNames", launchTemplateNames)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeLaunchTemplatesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ) extends zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly {
    override val launchTemplateIds: Option[List[LaunchTemplateId]] = scala
      .Option(impl.launchTemplateIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LaunchTemplateId(item)
        }.toList
      )
    override val launchTemplateNames: Option[List[LaunchTemplateName]] = scala
      .Option(impl.launchTemplateNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LaunchTemplateName(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeLaunchTemplatesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeLaunchTemplatesMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ): zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
