package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeConversionTasksResponse(
    conversionTasks: Option[Iterable[zio.aws.ec2.model.ConversionTask]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse = {
    import DescribeConversionTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse
      .builder()
      .optionallyWith(
        conversionTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conversionTasks)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeConversionTasksResponse.wrap(buildAwsValue())
}
object DescribeConversionTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeConversionTasksResponse =
      zio.aws.ec2.model.DescribeConversionTasksResponse(
        conversionTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conversionTasks: Option[List[zio.aws.ec2.model.ConversionTask.ReadOnly]]
    def getConversionTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ConversionTask.ReadOnly]] =
      AwsError.unwrapOptionField("conversionTasks", conversionTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse
  ) extends zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly {
    override val conversionTasks
        : Option[List[zio.aws.ec2.model.ConversionTask.ReadOnly]] = scala
      .Option(impl.conversionTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ConversionTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse
  ): zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
