package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountAttributesResponse(
    accountAttributes: Option[Iterable[zio.aws.ec2.model.AccountAttribute]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(
        accountAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAttributes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAccountAttributesResponse.wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAccountAttributesResponse =
      zio.aws.ec2.model.DescribeAccountAttributesResponse(
        accountAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountAttributes
        : Option[List[zio.aws.ec2.model.AccountAttribute.ReadOnly]]
    def getAccountAttributes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccountAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("accountAttributes", accountAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse
  ) extends zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly {
    override val accountAttributes
        : Option[List[zio.aws.ec2.model.AccountAttribute.ReadOnly]] = scala
      .Option(impl.accountAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccountAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse
  ): zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
