package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NatGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNatGatewayRequest(natGatewayId: NatGatewayId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest = {
    import DeleteNatGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
      .builder()
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNatGatewayRequest.wrap(buildAwsValue())
}
object DeleteNatGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNatGatewayRequest =
      zio.aws.ec2.model.DeleteNatGatewayRequest(natGatewayId)
    def natGatewayId: NatGatewayId
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ) extends zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly {
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest
  ): zio.aws.ec2.model.DeleteNatGatewayRequest.ReadOnly = new Wrapper(impl)
}
