package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{KeyPairId, KeyPairName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteKeyPairRequest(
    keyName: Option[KeyPairName] = None,
    keyPairId: Option[KeyPairId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest = {
    import DeleteKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
      .builder()
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        keyPairId.map(value => KeyPairId.unwrap(value): java.lang.String)
      )(_.keyPairId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly =
    zio.aws.ec2.model.DeleteKeyPairRequest.wrap(buildAwsValue())
}
object DeleteKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteKeyPairRequest =
      zio.aws.ec2.model.DeleteKeyPairRequest(
        keyName.map(value => value),
        keyPairId.map(value => value)
      )
    def keyName: Option[KeyPairName]
    def keyPairId: Option[KeyPairId]
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyPairId: ZIO[Any, AwsError, KeyPairId] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ) extends zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly {
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val keyPairId: Option[KeyPairId] = scala
      .Option(impl.keyPairId())
      .map(value => zio.aws.ec2.model.primitives.KeyPairId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ): zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly = new Wrapper(impl)
}
