package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DefaultTargetCapacityType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType
}
object DefaultTargetCapacityType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType
  ): zio.aws.ec2.model.DefaultTargetCapacityType = value match {
    case software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.SPOT =>
      val r = spot
      r
    case software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.ON_DEMAND =>
      val r = `on-demand`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DefaultTargetCapacityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType =
      software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.UNKNOWN_TO_SDK_VERSION
  }
  case object spot extends zio.aws.ec2.model.DefaultTargetCapacityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType =
      software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.SPOT
  }
  case object `on-demand` extends zio.aws.ec2.model.DefaultTargetCapacityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType =
      software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType.ON_DEMAND
  }
}
