package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpnGatewayResponse(
    vpnGateway: Option[zio.aws.ec2.model.VpnGateway] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse = {
    import CreateVpnGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse
      .builder()
      .optionallyWith(vpnGateway.map(value => value.buildAwsValue()))(
        _.vpnGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpnGatewayResponse.wrap(buildAwsValue())
}
object CreateVpnGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnGatewayResponse =
      zio.aws.ec2.model
        .CreateVpnGatewayResponse(vpnGateway.map(value => value.asEditable))
    def vpnGateway: Option[zio.aws.ec2.model.VpnGateway.ReadOnly]
    def getVpnGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnGateway.ReadOnly] =
      AwsError.unwrapOptionField("vpnGateway", vpnGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse
  ) extends zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly {
    override val vpnGateway: Option[zio.aws.ec2.model.VpnGateway.ReadOnly] =
      scala
        .Option(impl.vpnGateway())
        .map(value => zio.aws.ec2.model.VpnGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse
  ): zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly = new Wrapper(impl)
}
