package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointConnectionNotificationResponse(
    connectionNotification: Option[zio.aws.ec2.model.ConnectionNotification] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse = {
    import CreateVpcEndpointConnectionNotificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse
      .builder()
      .optionallyWith(
        connectionNotification.map(value => value.buildAwsValue())
      )(_.connectionNotification)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse
      .wrap(buildAwsValue())
}
object CreateVpcEndpointConnectionNotificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse =
      zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse(
        connectionNotification.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def connectionNotification
        : Option[zio.aws.ec2.model.ConnectionNotification.ReadOnly]
    def clientToken: Option[String]
    def getConnectionNotification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ConnectionNotification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectionNotification",
      connectionNotification
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse
  ) extends zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly {
    override val connectionNotification
        : Option[zio.aws.ec2.model.ConnectionNotification.ReadOnly] = scala
      .Option(impl.connectionNotification())
      .map(value => zio.aws.ec2.model.ConnectionNotification.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse
  ): zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly =
    new Wrapper(impl)
}
