package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, AllocationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNatGatewayRequest(
    allocationId: Option[AllocationId] = None,
    clientToken: Option[String] = None,
    subnetId: SubnetId,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    connectivityType: Option[zio.aws.ec2.model.ConnectivityType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest = {
    import CreateNatGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
      .builder()
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(connectivityType.map(value => value.unwrap))(
        _.connectivityType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly =
    zio.aws.ec2.model.CreateNatGatewayRequest.wrap(buildAwsValue())
}
object CreateNatGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNatGatewayRequest =
      zio.aws.ec2.model.CreateNatGatewayRequest(
        allocationId.map(value => value),
        clientToken.map(value => value),
        subnetId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectivityType.map(value => value)
      )
    def allocationId: Option[AllocationId]
    def clientToken: Option[String]
    def subnetId: SubnetId
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def connectivityType: Option[zio.aws.ec2.model.ConnectivityType]
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getConnectivityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectivityType] =
      AwsError.unwrapOptionField("connectivityType", connectivityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ) extends zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly {
    override val allocationId: Option[AllocationId] = scala
      .Option(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val connectivityType: Option[zio.aws.ec2.model.ConnectivityType] =
      scala
        .Option(impl.connectivityType())
        .map(value => zio.aws.ec2.model.ConnectivityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ): zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly = new Wrapper(impl)
}
