package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFlowLogsResponse(
    clientToken: Option[String] = None,
    flowLogIds: Option[Iterable[String]] = None,
    unsuccessful: Option[Iterable[zio.aws.ec2.model.UnsuccessfulItem]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse = {
    import CreateFlowLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        flowLogIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.flowLogIds)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly =
    zio.aws.ec2.model.CreateFlowLogsResponse.wrap(buildAwsValue())
}
object CreateFlowLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFlowLogsResponse =
      zio.aws.ec2.model.CreateFlowLogsResponse(
        clientToken.map(value => value),
        flowLogIds.map(value => value),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Option[String]
    def flowLogIds: Option[List[String]]
    def unsuccessful: Option[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFlowLogIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("flowLogIds", flowLogIds)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.UnsuccessfulItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse
  ) extends zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val flowLogIds: Option[List[String]] = scala
      .Option(impl.flowLogIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val unsuccessful
        : Option[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]] = scala
      .Option(impl.unsuccessful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UnsuccessfulItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse
  ): zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly = new Wrapper(impl)
}
