package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnRouteStatus(
    code: Option[zio.aws.ec2.model.ClientVpnRouteStatusCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus = {
    import ClientVpnRouteStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly =
    zio.aws.ec2.model.ClientVpnRouteStatus.wrap(buildAwsValue())
}
object ClientVpnRouteStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnRouteStatus =
      zio.aws.ec2.model.ClientVpnRouteStatus(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.ec2.model.ClientVpnRouteStatusCode]
    def message: Option[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnRouteStatusCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus
  ) extends zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly {
    override val code: Option[zio.aws.ec2.model.ClientVpnRouteStatusCode] =
      scala
        .Option(impl.code())
        .map(value => zio.aws.ec2.model.ClientVpnRouteStatusCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus
  ): zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly = new Wrapper(impl)
}
