package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociatedTargetNetwork(
    networkId: Option[String] = None,
    networkType: Option[zio.aws.ec2.model.AssociatedNetworkType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork = {
    import AssociatedTargetNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork
      .builder()
      .optionallyWith(networkId.map(value => value: java.lang.String))(
        _.networkId
      )
      .optionallyWith(networkType.map(value => value.unwrap))(_.networkType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly =
    zio.aws.ec2.model.AssociatedTargetNetwork.wrap(buildAwsValue())
}
object AssociatedTargetNetwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociatedTargetNetwork =
      zio.aws.ec2.model.AssociatedTargetNetwork(
        networkId.map(value => value),
        networkType.map(value => value)
      )
    def networkId: Option[String]
    def networkType: Option[zio.aws.ec2.model.AssociatedNetworkType]
    def getNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getNetworkType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AssociatedNetworkType] =
      AwsError.unwrapOptionField("networkType", networkType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork
  ) extends zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly {
    override val networkId: Option[String] =
      scala.Option(impl.networkId()).map(value => value: String)
    override val networkType: Option[zio.aws.ec2.model.AssociatedNetworkType] =
      scala
        .Option(impl.networkType())
        .map(value => zio.aws.ec2.model.AssociatedNetworkType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork
  ): zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly = new Wrapper(impl)
}
