package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayMulticastDomainResponse(
    associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse = {
    import AssociateTransitGatewayMulticastDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
      .builder()
      .optionallyWith(associations.map(value => value.buildAwsValue()))(
        _.associations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayMulticastDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse =
      zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse(
        associations.map(value => value.asEditable)
      )
    def associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ]
    def getAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ) extends zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly {
    override val associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = scala
      .Option(impl.associations())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ): zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly =
    new Wrapper(impl)
}
