package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AcceptVpcPeeringConnectionRequest(
    vpcPeeringConnectionId: Option[VpcPeeringConnectionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest = {
    import AcceptVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
      .builder()
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          VpcPeeringConnectionId.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object AcceptVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest =
      zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest(
        vpcPeeringConnectionId.map(value => value)
      )
    def vpcPeeringConnectionId: Option[VpcPeeringConnectionId]
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, VpcPeeringConnectionId] =
      AwsError.unwrapOptionField(
        "vpcPeeringConnectionId",
        vpcPeeringConnectionId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly {
    override val vpcPeeringConnectionId: Option[VpcPeeringConnectionId] = scala
      .Option(impl.vpcPeeringConnectionId())
      .map(value => zio.aws.ec2.model.primitives.VpcPeeringConnectionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
