package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpcEndpointType {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpcEndpointType
}
object VpcEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpcEndpointType
  ): zio.aws.ec2.model.VpcEndpointType = value match {
    case software.amazon.awssdk.services.ec2.model.VpcEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpcEndpointType.INTERFACE =>
      val r = Interface
      r
    case software.amazon.awssdk.services.ec2.model.VpcEndpointType.GATEWAY =>
      val r = Gateway
      r
    case software.amazon.awssdk.services.ec2.model.VpcEndpointType.GATEWAY_LOAD_BALANCER =>
      val r = GatewayLoadBalancer
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpcEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcEndpointType =
      software.amazon.awssdk.services.ec2.model.VpcEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object Interface extends zio.aws.ec2.model.VpcEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcEndpointType =
      software.amazon.awssdk.services.ec2.model.VpcEndpointType.INTERFACE
  }
  case object Gateway extends zio.aws.ec2.model.VpcEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcEndpointType =
      software.amazon.awssdk.services.ec2.model.VpcEndpointType.GATEWAY
  }
  case object GatewayLoadBalancer extends zio.aws.ec2.model.VpcEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcEndpointType =
      software.amazon.awssdk.services.ec2.model.VpcEndpointType.GATEWAY_LOAD_BALANCER
  }
}
