package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SpotFleetRequestConfigData(
    allocationStrategy: Option[zio.aws.ec2.model.AllocationStrategy] = None,
    onDemandAllocationStrategy: Option[
      zio.aws.ec2.model.OnDemandAllocationStrategy
    ] = None,
    spotMaintenanceStrategies: Option[
      zio.aws.ec2.model.SpotMaintenanceStrategies
    ] = None,
    clientToken: Option[String] = None,
    excessCapacityTerminationPolicy: Option[
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = None,
    fulfilledCapacity: Option[Double] = None,
    onDemandFulfilledCapacity: Option[Double] = None,
    iamFleetRole: String,
    launchSpecifications: Option[
      Iterable[zio.aws.ec2.model.SpotFleetLaunchSpecification]
    ] = None,
    launchTemplateConfigs: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateConfig]
    ] = None,
    spotPrice: Option[String] = None,
    targetCapacity: Integer,
    onDemandTargetCapacity: Option[Integer] = None,
    onDemandMaxTotalPrice: Option[String] = None,
    spotMaxTotalPrice: Option[String] = None,
    terminateInstancesWithExpiration: Option[Boolean] = None,
    `type`: Option[zio.aws.ec2.model.FleetType] = None,
    validFrom: Option[DateTime] = None,
    validUntil: Option[DateTime] = None,
    replaceUnhealthyInstances: Option[Boolean] = None,
    instanceInterruptionBehavior: Option[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = None,
    loadBalancersConfig: Option[zio.aws.ec2.model.LoadBalancersConfig] = None,
    instancePoolsToUseCount: Option[Integer] = None,
    context: Option[String] = None,
    targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType] =
      None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData = {
    import SpotFleetRequestConfigData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
      .builder()
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(onDemandAllocationStrategy.map(value => value.unwrap))(
        _.onDemandAllocationStrategy
      )
      .optionallyWith(
        spotMaintenanceStrategies.map(value => value.buildAwsValue())
      )(_.spotMaintenanceStrategies)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(
        onDemandFulfilledCapacity.map(value => value: java.lang.Double)
      )(_.onDemandFulfilledCapacity)
      .iamFleetRole(iamFleetRole: java.lang.String)
      .optionallyWith(
        launchSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchSpecifications)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .targetCapacity(Integer.unwrap(targetCapacity): java.lang.Integer)
      .optionallyWith(
        onDemandTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.onDemandTargetCapacity)
      .optionallyWith(
        onDemandMaxTotalPrice.map(value => value: java.lang.String)
      )(_.onDemandMaxTotalPrice)
      .optionallyWith(spotMaxTotalPrice.map(value => value: java.lang.String))(
        _.spotMaxTotalPrice
      )
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .optionallyWith(loadBalancersConfig.map(value => value.buildAwsValue()))(
        _.loadBalancersConfig
      )
      .optionallyWith(
        instancePoolsToUseCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.instancePoolsToUseCount)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly =
    zio.aws.ec2.model.SpotFleetRequestConfigData.wrap(buildAwsValue())
}
object SpotFleetRequestConfigData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetRequestConfigData =
      zio.aws.ec2.model.SpotFleetRequestConfigData(
        allocationStrategy.map(value => value),
        onDemandAllocationStrategy.map(value => value),
        spotMaintenanceStrategies.map(value => value.asEditable),
        clientToken.map(value => value),
        excessCapacityTerminationPolicy.map(value => value),
        fulfilledCapacity.map(value => value),
        onDemandFulfilledCapacity.map(value => value),
        iamFleetRole,
        launchSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spotPrice.map(value => value),
        targetCapacity,
        onDemandTargetCapacity.map(value => value),
        onDemandMaxTotalPrice.map(value => value),
        spotMaxTotalPrice.map(value => value),
        terminateInstancesWithExpiration.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        replaceUnhealthyInstances.map(value => value),
        instanceInterruptionBehavior.map(value => value),
        loadBalancersConfig.map(value => value.asEditable),
        instancePoolsToUseCount.map(value => value),
        context.map(value => value),
        targetCapacityUnitType.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allocationStrategy: Option[zio.aws.ec2.model.AllocationStrategy]
    def onDemandAllocationStrategy
        : Option[zio.aws.ec2.model.OnDemandAllocationStrategy]
    def spotMaintenanceStrategies
        : Option[zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly]
    def clientToken: Option[String]
    def excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.ExcessCapacityTerminationPolicy]
    def fulfilledCapacity: Option[Double]
    def onDemandFulfilledCapacity: Option[Double]
    def iamFleetRole: String
    def launchSpecifications
        : Option[List[zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly]]
    def launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]]
    def spotPrice: Option[String]
    def targetCapacity: Integer
    def onDemandTargetCapacity: Option[Integer]
    def onDemandMaxTotalPrice: Option[String]
    def spotMaxTotalPrice: Option[String]
    def terminateInstancesWithExpiration: Option[Boolean]
    def `type`: Option[zio.aws.ec2.model.FleetType]
    def validFrom: Option[DateTime]
    def validUntil: Option[DateTime]
    def replaceUnhealthyInstances: Option[Boolean]
    def instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def loadBalancersConfig
        : Option[zio.aws.ec2.model.LoadBalancersConfig.ReadOnly]
    def instancePoolsToUseCount: Option[Integer]
    def context: Option[String]
    def targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.AllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getOnDemandAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.OnDemandAllocationStrategy] =
      AwsError.unwrapOptionField(
        "onDemandAllocationStrategy",
        onDemandAllocationStrategy
      )
    def getSpotMaintenanceStrategies: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotMaintenanceStrategies",
      spotMaintenanceStrategies
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getOnDemandFulfilledCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("onDemandFulfilledCapacity", onDemandFulfilledCapacity)
    def getIamFleetRole: ZIO[Any, Nothing, String] = ZIO.succeed(iamFleetRole)
    def getLaunchSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getTargetCapacity: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(targetCapacity)
    def getOnDemandTargetCapacity: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("onDemandTargetCapacity", onDemandTargetCapacity)
    def getOnDemandMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onDemandMaxTotalPrice", onDemandMaxTotalPrice)
    def getSpotMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotMaxTotalPrice", spotMaxTotalPrice)
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
    def getLoadBalancersConfig
        : ZIO[Any, AwsError, zio.aws.ec2.model.LoadBalancersConfig.ReadOnly] =
      AwsError.unwrapOptionField("loadBalancersConfig", loadBalancersConfig)
    def getInstancePoolsToUseCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("instancePoolsToUseCount", instancePoolsToUseCount)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ) extends zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly {
    override val allocationStrategy
        : Option[zio.aws.ec2.model.AllocationStrategy] = scala
      .Option(impl.allocationStrategy())
      .map(value => zio.aws.ec2.model.AllocationStrategy.wrap(value))
    override val onDemandAllocationStrategy
        : Option[zio.aws.ec2.model.OnDemandAllocationStrategy] = scala
      .Option(impl.onDemandAllocationStrategy())
      .map(value => zio.aws.ec2.model.OnDemandAllocationStrategy.wrap(value))
    override val spotMaintenanceStrategies
        : Option[zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly] = scala
      .Option(impl.spotMaintenanceStrategies())
      .map(value => zio.aws.ec2.model.SpotMaintenanceStrategies.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.ExcessCapacityTerminationPolicy] = scala
      .Option(impl.excessCapacityTerminationPolicy())
      .map(value =>
        zio.aws.ec2.model.ExcessCapacityTerminationPolicy.wrap(value)
      )
    override val fulfilledCapacity: Option[Double] =
      scala.Option(impl.fulfilledCapacity()).map(value => value: Double)
    override val onDemandFulfilledCapacity: Option[Double] =
      scala.Option(impl.onDemandFulfilledCapacity()).map(value => value: Double)
    override val iamFleetRole: String = impl.iamFleetRole(): String
    override val launchSpecifications: Option[
      List[zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly]
    ] = scala
      .Option(impl.launchSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SpotFleetLaunchSpecification.wrap(item)
        }.toList
      )
    override val launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]] = scala
      .Option(impl.launchTemplateConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateConfig.wrap(item)
        }.toList
      )
    override val spotPrice: Option[String] =
      scala.Option(impl.spotPrice()).map(value => value: String)
    override val targetCapacity: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.targetCapacity())
    override val onDemandTargetCapacity: Option[Integer] = scala
      .Option(impl.onDemandTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val onDemandMaxTotalPrice: Option[String] =
      scala.Option(impl.onDemandMaxTotalPrice()).map(value => value: String)
    override val spotMaxTotalPrice: Option[String] =
      scala.Option(impl.spotMaxTotalPrice()).map(value => value: String)
    override val terminateInstancesWithExpiration: Option[Boolean] = scala
      .Option(impl.terminateInstancesWithExpiration())
      .map(value => value: Boolean)
    override val `type`: Option[zio.aws.ec2.model.FleetType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Option[DateTime] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Option[Boolean] = scala
      .Option(impl.replaceUnhealthyInstances())
      .map(value => value: Boolean)
    override val instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior] = scala
      .Option(impl.instanceInterruptionBehavior())
      .map(value => zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value))
    override val loadBalancersConfig
        : Option[zio.aws.ec2.model.LoadBalancersConfig.ReadOnly] = scala
      .Option(impl.loadBalancersConfig())
      .map(value => zio.aws.ec2.model.LoadBalancersConfig.wrap(value))
    override val instancePoolsToUseCount: Option[Integer] = scala
      .Option(impl.instancePoolsToUseCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
    override val targetCapacityUnitType
        : Option[zio.aws.ec2.model.TargetCapacityUnitType] = scala
      .Option(impl.targetCapacityUnitType())
      .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ): zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly = new Wrapper(impl)
}
