package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesBlockDeviceMapping(
    deviceName: Option[String] = None,
    ebs: Option[zio.aws.ec2.model.ScheduledInstancesEbs] = None,
    noDevice: Option[String] = None,
    virtualName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping = {
    import ScheduledInstancesBlockDeviceMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping
      .builder()
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(noDevice.map(value => value: java.lang.String))(
        _.noDevice
      )
      .optionallyWith(virtualName.map(value => value: java.lang.String))(
        _.virtualName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.wrap(buildAwsValue())
}
object ScheduledInstancesBlockDeviceMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping =
      zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping(
        deviceName.map(value => value),
        ebs.map(value => value.asEditable),
        noDevice.map(value => value),
        virtualName.map(value => value)
      )
    def deviceName: Option[String]
    def ebs: Option[zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly]
    def noDevice: Option[String]
    def virtualName: Option[String]
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getEbs
        : ZIO[Any, AwsError, zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly] =
      AwsError.unwrapOptionField("ebs", ebs)
    def getNoDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("noDevice", noDevice)
    def getVirtualName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("virtualName", virtualName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping
  ) extends zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly {
    override val deviceName: Option[String] =
      scala.Option(impl.deviceName()).map(value => value: String)
    override val ebs: Option[zio.aws.ec2.model.ScheduledInstancesEbs.ReadOnly] =
      scala
        .Option(impl.ebs())
        .map(value => zio.aws.ec2.model.ScheduledInstancesEbs.wrap(value))
    override val noDevice: Option[String] =
      scala.Option(impl.noDevice()).map(value => value: String)
    override val virtualName: Option[String] =
      scala.Option(impl.virtualName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping
  ): zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly =
    new Wrapper(impl)
}
