package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedInstanceLimitPrice(
    amount: Option[Double] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice = {
    import ReservedInstanceLimitPrice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Double))(_.amount)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly =
    zio.aws.ec2.model.ReservedInstanceLimitPrice.wrap(buildAwsValue())
}
object ReservedInstanceLimitPrice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstanceLimitPrice =
      zio.aws.ec2.model.ReservedInstanceLimitPrice(
        amount.map(value => value),
        currencyCode.map(value => value)
      )
    def amount: Option[Double]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def getAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("amount", amount)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice
  ) extends zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly {
    override val amount: Option[Double] =
      scala.Option(impl.amount()).map(value => value: Double)
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice
  ): zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly = new Wrapper(impl)
}
