package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReleaseHostsResponse(
    successful: Option[Iterable[String]] = None,
    unsuccessful: Option[Iterable[zio.aws.ec2.model.UnsuccessfulItem]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse = {
    import ReleaseHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly =
    zio.aws.ec2.model.ReleaseHostsResponse.wrap(buildAwsValue())
}
object ReleaseHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReleaseHostsResponse =
      zio.aws.ec2.model.ReleaseHostsResponse(
        successful.map(value => value),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful: Option[List[String]]
    def unsuccessful: Option[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]]
    def getSuccessful: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.UnsuccessfulItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse
  ) extends zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly {
    override val successful: Option[List[String]] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val unsuccessful
        : Option[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]] = scala
      .Option(impl.unsuccessful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UnsuccessfulItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse
  ): zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly = new Wrapper(impl)
}
