package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DedicatedHostId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReleaseHostsRequest(hostIds: Iterable[DedicatedHostId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest = {
    import ReleaseHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest
      .builder()
      .hostIds(hostIds.map { item =>
        DedicatedHostId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReleaseHostsRequest.ReadOnly =
    zio.aws.ec2.model.ReleaseHostsRequest.wrap(buildAwsValue())
}
object ReleaseHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReleaseHostsRequest =
      zio.aws.ec2.model.ReleaseHostsRequest(hostIds)
    def hostIds: List[DedicatedHostId]
    def getHostIds: ZIO[Any, Nothing, List[DedicatedHostId]] =
      ZIO.succeed(hostIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest
  ) extends zio.aws.ec2.model.ReleaseHostsRequest.ReadOnly {
    override val hostIds: List[DedicatedHostId] = impl
      .hostIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.DedicatedHostId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest
  ): zio.aws.ec2.model.ReleaseHostsRequest.ReadOnly = new Wrapper(impl)
}
