package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrefixListEntry(
    cidr: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrefixListEntry = {
    import PrefixListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrefixListEntry
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrefixListEntry.ReadOnly =
    zio.aws.ec2.model.PrefixListEntry.wrap(buildAwsValue())
}
object PrefixListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrefixListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrefixListEntry =
      zio.aws.ec2.model.PrefixListEntry(
        cidr.map(value => value),
        description.map(value => value)
      )
    def cidr: Option[String]
    def description: Option[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListEntry
  ) extends zio.aws.ec2.model.PrefixListEntry.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListEntry
  ): zio.aws.ec2.model.PrefixListEntry.ReadOnly = new Wrapper(impl)
}
