package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcAttributeRequest(
    enableDnsHostnames: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    enableDnsSupport: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest = {
    import ModifyVpcAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest
      .builder()
      .optionallyWith(enableDnsHostnames.map(value => value.buildAwsValue()))(
        _.enableDnsHostnames
      )
      .optionallyWith(enableDnsSupport.map(value => value.buildAwsValue()))(
        _.enableDnsSupport
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpcAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcAttributeRequest.wrap(buildAwsValue())
}
object ModifyVpcAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcAttributeRequest =
      zio.aws.ec2.model.ModifyVpcAttributeRequest(
        enableDnsHostnames.map(value => value.asEditable),
        enableDnsSupport.map(value => value.asEditable),
        vpcId
      )
    def enableDnsHostnames
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enableDnsSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def vpcId: VpcId
    def getEnableDnsHostnames
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDnsHostnames", enableDnsHostnames)
    def getEnableDnsSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enableDnsSupport", enableDnsSupport)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest
  ) extends zio.aws.ec2.model.ModifyVpcAttributeRequest.ReadOnly {
    override val enableDnsHostnames
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableDnsHostnames())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enableDnsSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enableDnsSupport())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest
  ): zio.aws.ec2.model.ModifyVpcAttributeRequest.ReadOnly = new Wrapper(impl)
}
