package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DedicatedHostId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyHostsRequest(
    autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = None,
    hostIds: Iterable[DedicatedHostId],
    hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = None,
    instanceType: Option[String] = None,
    instanceFamily: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyHostsRequest = {
    import ModifyHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .hostIds(hostIds.map { item =>
        DedicatedHostId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyHostsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyHostsRequest.wrap(buildAwsValue())
}
object ModifyHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyHostsRequest =
      zio.aws.ec2.model.ModifyHostsRequest(
        autoPlacement.map(value => value),
        hostIds,
        hostRecovery.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value)
      )
    def autoPlacement: Option[zio.aws.ec2.model.AutoPlacement]
    def hostIds: List[DedicatedHostId]
    def hostRecovery: Option[zio.aws.ec2.model.HostRecovery]
    def instanceType: Option[String]
    def instanceFamily: Option[String]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getHostIds: ZIO[Any, Nothing, List[DedicatedHostId]] =
      ZIO.succeed(hostIds)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ) extends zio.aws.ec2.model.ModifyHostsRequest.ReadOnly {
    override val autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = scala
      .Option(impl.autoPlacement())
      .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val hostIds: List[DedicatedHostId] = impl
      .hostIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.DedicatedHostId(item)
      }
      .toList
    override val hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = scala
      .Option(impl.hostRecovery())
      .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val instanceFamily: Option[String] =
      scala.Option(impl.instanceFamily()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ): zio.aws.ec2.model.ModifyHostsRequest.ReadOnly = new Wrapper(impl)
}
