package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplatePrivateDnsNameOptions(
    hostnameType: Option[zio.aws.ec2.model.HostnameType] = None,
    enableResourceNameDnsARecord: Option[Boolean] = None,
    enableResourceNameDnsAAAARecord: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions = {
    import LaunchTemplatePrivateDnsNameOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions
      .builder()
      .optionallyWith(hostnameType.map(value => value.unwrap))(_.hostnameType)
      .optionallyWith(
        enableResourceNameDnsARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsARecord)
      .optionallyWith(
        enableResourceNameDnsAAAARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsAAAARecord)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly =
    zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.wrap(buildAwsValue())
}
object LaunchTemplatePrivateDnsNameOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions =
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions(
        hostnameType.map(value => value),
        enableResourceNameDnsARecord.map(value => value),
        enableResourceNameDnsAAAARecord.map(value => value)
      )
    def hostnameType: Option[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecord: Option[Boolean]
    def enableResourceNameDnsAAAARecord: Option[Boolean]
    def getHostnameType: ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] =
      AwsError.unwrapOptionField("hostnameType", hostnameType)
    def getEnableResourceNameDnsARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecord",
        enableResourceNameDnsARecord
      )
    def getEnableResourceNameDnsAAAARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecord",
        enableResourceNameDnsAAAARecord
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions
  ) extends zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly {
    override val hostnameType: Option[zio.aws.ec2.model.HostnameType] = scala
      .Option(impl.hostnameType())
      .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecord: Option[Boolean] = scala
      .Option(impl.enableResourceNameDnsARecord())
      .map(value => value: Boolean)
    override val enableResourceNameDnsAAAARecord: Option[Boolean] = scala
      .Option(impl.enableResourceNameDnsAAAARecord())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions
  ): zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly =
    new Wrapper(impl)
}
