package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceMarketOptionsRequest(
    marketType: Option[zio.aws.ec2.model.MarketType] = None,
    spotOptions: Option[
      zio.aws.ec2.model.LaunchTemplateSpotMarketOptionsRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest = {
    import LaunchTemplateInstanceMarketOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
      .builder()
      .optionallyWith(marketType.map(value => value.unwrap))(_.marketType)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateInstanceMarketOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest =
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest(
        marketType.map(value => value),
        spotOptions.map(value => value.asEditable)
      )
    def marketType: Option[zio.aws.ec2.model.MarketType]
    def spotOptions: Option[
      zio.aws.ec2.model.LaunchTemplateSpotMarketOptionsRequest.ReadOnly
    ]
    def getMarketType: ZIO[Any, AwsError, zio.aws.ec2.model.MarketType] =
      AwsError.unwrapOptionField("marketType", marketType)
    def getSpotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateSpotMarketOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("spotOptions", spotOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly {
    override val marketType: Option[zio.aws.ec2.model.MarketType] = scala
      .Option(impl.marketType())
      .map(value => zio.aws.ec2.model.MarketType.wrap(value))
    override val spotOptions: Option[
      zio.aws.ec2.model.LaunchTemplateSpotMarketOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.spotOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateSpotMarketOptionsRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
  ): zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
