package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Ipv6CidrAssociation(
    ipv6Cidr: Option[String] = None,
    associatedResource: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation = {
    import Ipv6CidrAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation
      .builder()
      .optionallyWith(ipv6Cidr.map(value => value: java.lang.String))(
        _.ipv6Cidr
      )
      .optionallyWith(associatedResource.map(value => value: java.lang.String))(
        _.associatedResource
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly =
    zio.aws.ec2.model.Ipv6CidrAssociation.wrap(buildAwsValue())
}
object Ipv6CidrAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6CidrAssociation =
      zio.aws.ec2.model.Ipv6CidrAssociation(
        ipv6Cidr.map(value => value),
        associatedResource.map(value => value)
      )
    def ipv6Cidr: Option[String]
    def associatedResource: Option[String]
    def getIpv6Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Cidr", ipv6Cidr)
    def getAssociatedResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associatedResource", associatedResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation
  ) extends zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly {
    override val ipv6Cidr: Option[String] =
      scala.Option(impl.ipv6Cidr()).map(value => value: String)
    override val associatedResource: Option[String] =
      scala.Option(impl.associatedResource()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation
  ): zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly = new Wrapper(impl)
}
