package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpPermission(
    fromPort: Option[Integer] = None,
    ipProtocol: Option[String] = None,
    ipRanges: Option[Iterable[zio.aws.ec2.model.IpRange]] = None,
    ipv6Ranges: Option[Iterable[zio.aws.ec2.model.Ipv6Range]] = None,
    prefixListIds: Option[Iterable[zio.aws.ec2.model.PrefixListId]] = None,
    toPort: Option[Integer] = None,
    userIdGroupPairs: Option[Iterable[zio.aws.ec2.model.UserIdGroupPair]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpPermission = {
    import IpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpPermission
      .builder()
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        ipv6Ranges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Ranges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpPermission.ReadOnly =
    zio.aws.ec2.model.IpPermission.wrap(buildAwsValue())
}
object IpPermission {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpPermission] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpPermission =
      zio.aws.ec2.model.IpPermission(
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Ranges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromPort: Option[Integer]
    def ipProtocol: Option[String]
    def ipRanges: Option[List[zio.aws.ec2.model.IpRange.ReadOnly]]
    def ipv6Ranges: Option[List[zio.aws.ec2.model.Ipv6Range.ReadOnly]]
    def prefixListIds: Option[List[zio.aws.ec2.model.PrefixListId.ReadOnly]]
    def toPort: Option[Integer]
    def userIdGroupPairs
        : Option[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getIpRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpRange.ReadOnly]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getIpv6Ranges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipv6Range.ReadOnly]] =
      AwsError.unwrapOptionField("ipv6Ranges", ipv6Ranges)
    def getPrefixListIds
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PrefixListId.ReadOnly]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpPermission
  ) extends zio.aws.ec2.model.IpPermission.ReadOnly {
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val ipRanges: Option[List[zio.aws.ec2.model.IpRange.ReadOnly]] =
      scala
        .Option(impl.ipRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpRange.wrap(item)
          }.toList
        )
    override val ipv6Ranges
        : Option[List[zio.aws.ec2.model.Ipv6Range.ReadOnly]] = scala
      .Option(impl.ipv6Ranges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6Range.wrap(item)
        }.toList
      )
    override val prefixListIds
        : Option[List[zio.aws.ec2.model.PrefixListId.ReadOnly]] = scala
      .Option(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrefixListId.wrap(item)
        }.toList
      )
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val userIdGroupPairs
        : Option[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] = scala
      .Option(impl.userIdGroupPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UserIdGroupPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpPermission
  ): zio.aws.ec2.model.IpPermission.ReadOnly = new Wrapper(impl)
}
