package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceIpv6Prefix(ipv6Prefix: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix = {
    import InstanceIpv6Prefix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix
      .builder()
      .optionallyWith(ipv6Prefix.map(value => value: java.lang.String))(
        _.ipv6Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly =
    zio.aws.ec2.model.InstanceIpv6Prefix.wrap(buildAwsValue())
}
object InstanceIpv6Prefix {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceIpv6Prefix =
      zio.aws.ec2.model.InstanceIpv6Prefix(ipv6Prefix.map(value => value))
    def ipv6Prefix: Option[String]
    def getIpv6Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Prefix", ipv6Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix
  ) extends zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly {
    override val ipv6Prefix: Option[String] =
      scala.Option(impl.ipv6Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix
  ): zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly = new Wrapper(impl)
}
