package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayRouteTablePropagationsResponse(
    transitGatewayRouteTablePropagations: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteTablePropagation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse = {
    import GetTransitGatewayRouteTablePropagationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTablePropagations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayRouteTablePropagations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayRouteTablePropagationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse =
      zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse(
        transitGatewayRouteTablePropagations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayRouteTablePropagations: Option[
      List[zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly]
    ]
    def nextToken: Option[String]
    def getTransitGatewayRouteTablePropagations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayRouteTablePropagations",
      transitGatewayRouteTablePropagations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly {
    override val transitGatewayRouteTablePropagations: Option[
      List[zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly]
    ] = scala
      .Option(impl.transitGatewayRouteTablePropagations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayRouteTablePropagation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse
  ): zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly =
    new Wrapper(impl)
}
