package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FastLaunchResourceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.FastLaunchResourceType
}
object FastLaunchResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FastLaunchResourceType
  ): zio.aws.ec2.model.FastLaunchResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.FastLaunchResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchResourceType.SNAPSHOT =>
      val r = snapshot
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FastLaunchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchResourceType =
      software.amazon.awssdk.services.ec2.model.FastLaunchResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object snapshot extends zio.aws.ec2.model.FastLaunchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchResourceType =
      software.amazon.awssdk.services.ec2.model.FastLaunchResourceType.SNAPSHOT
  }
}
