package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupsResponse(
    securityGroups: Option[Iterable[zio.aws.ec2.model.SecurityGroup]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse = {
    import DescribeSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupsResponse.wrap(buildAwsValue())
}
object DescribeSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupsResponse =
      zio.aws.ec2.model.DescribeSecurityGroupsResponse(
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityGroups: Option[List[zio.aws.ec2.model.SecurityGroup.ReadOnly]]
    def nextToken: Option[String]
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SecurityGroup.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse
  ) extends zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly {
    override val securityGroups
        : Option[List[zio.aws.ec2.model.SecurityGroup.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SecurityGroup.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse
  ): zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
