package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIpamPoolsResponse(
    nextToken: Option[NextToken] = None,
    ipamPools: Option[Iterable[zio.aws.ec2.model.IpamPool]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse = {
    import DescribeIpamPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipamPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamPools)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamPoolsResponse.wrap(buildAwsValue())
}
object DescribeIpamPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpamPoolsResponse =
      zio.aws.ec2.model.DescribeIpamPoolsResponse(
        nextToken.map(value => value),
        ipamPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def ipamPools: Option[List[zio.aws.ec2.model.IpamPool.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamPools
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamPool.ReadOnly]] =
      AwsError.unwrapOptionField("ipamPools", ipamPools)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ) extends zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamPools: Option[List[zio.aws.ec2.model.IpamPool.ReadOnly]] =
      scala
        .Option(impl.ipamPools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamPool.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ): zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly = new Wrapper(impl)
}
