package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetCidrReservationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSubnetCidrReservationRequest(
    subnetCidrReservationId: SubnetCidrReservationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest = {
    import DeleteSubnetCidrReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
      .builder()
      .subnetCidrReservationId(
        SubnetCidrReservationId.unwrap(
          subnetCidrReservationId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.wrap(buildAwsValue())
}
object DeleteSubnetCidrReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSubnetCidrReservationRequest =
      zio.aws.ec2.model
        .DeleteSubnetCidrReservationRequest(subnetCidrReservationId)
    def subnetCidrReservationId: SubnetCidrReservationId
    def getSubnetCidrReservationId: ZIO[Any, Nothing, SubnetCidrReservationId] =
      ZIO.succeed(subnetCidrReservationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ) extends zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly {
    override val subnetCidrReservationId: SubnetCidrReservationId =
      zio.aws.ec2.model.primitives
        .SubnetCidrReservationId(impl.subnetCidrReservationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest
  ): zio.aws.ec2.model.DeleteSubnetCidrReservationRequest.ReadOnly =
    new Wrapper(impl)
}
