package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LaunchTemplateName, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateRequest(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest = {
    import DeleteLaunchTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteLaunchTemplateRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateRequest.wrap(buildAwsValue())
}
object DeleteLaunchTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLaunchTemplateRequest =
      zio.aws.ec2.model.DeleteLaunchTemplateRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value)
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateRequest.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest
  ): zio.aws.ec2.model.DeleteLaunchTemplateRequest.ReadOnly = new Wrapper(impl)
}
