package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{NetmaskLength, IpamPoolId, Ipv6PoolEc2Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcRequest(
    cidrBlock: Option[String] = None,
    amazonProvidedIpv6CidrBlock: Option[Boolean] = None,
    ipv6Pool: Option[Ipv6PoolEc2Id] = None,
    ipv6CidrBlock: Option[String] = None,
    ipv4IpamPoolId: Option[IpamPoolId] = None,
    ipv4NetmaskLength: Option[NetmaskLength] = None,
    ipv6IpamPoolId: Option[IpamPoolId] = None,
    ipv6NetmaskLength: Option[NetmaskLength] = None,
    instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    ipv6CidrBlockNetworkBorderGroup: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcRequest = {
    import CreateVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcRequest
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(
        amazonProvidedIpv6CidrBlock.map(value => value: java.lang.Boolean)
      )(_.amazonProvidedIpv6CidrBlock)
      .optionallyWith(
        ipv6Pool.map(value => Ipv6PoolEc2Id.unwrap(value): java.lang.String)
      )(_.ipv6Pool)
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(
        ipv4IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv4IpamPoolId)
      .optionallyWith(
        ipv4NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv4NetmaskLength)
      .optionallyWith(
        ipv6IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv6IpamPoolId)
      .optionallyWith(
        ipv6NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv6NetmaskLength)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(
        ipv6CidrBlockNetworkBorderGroup.map(value => value: java.lang.String)
      )(_.ipv6CidrBlockNetworkBorderGroup)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcRequest.wrap(buildAwsValue())
}
object CreateVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcRequest =
      zio.aws.ec2.model.CreateVpcRequest(
        cidrBlock.map(value => value),
        amazonProvidedIpv6CidrBlock.map(value => value),
        ipv6Pool.map(value => value),
        ipv6CidrBlock.map(value => value),
        ipv4IpamPoolId.map(value => value),
        ipv4NetmaskLength.map(value => value),
        ipv6IpamPoolId.map(value => value),
        ipv6NetmaskLength.map(value => value),
        instanceTenancy.map(value => value),
        ipv6CidrBlockNetworkBorderGroup.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cidrBlock: Option[String]
    def amazonProvidedIpv6CidrBlock: Option[Boolean]
    def ipv6Pool: Option[Ipv6PoolEc2Id]
    def ipv6CidrBlock: Option[String]
    def ipv4IpamPoolId: Option[IpamPoolId]
    def ipv4NetmaskLength: Option[NetmaskLength]
    def ipv6IpamPoolId: Option[IpamPoolId]
    def ipv6NetmaskLength: Option[NetmaskLength]
    def instanceTenancy: Option[zio.aws.ec2.model.Tenancy]
    def ipv6CidrBlockNetworkBorderGroup: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getAmazonProvidedIpv6CidrBlock: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "amazonProvidedIpv6CidrBlock",
        amazonProvidedIpv6CidrBlock
      )
    def getIpv6Pool: ZIO[Any, AwsError, Ipv6PoolEc2Id] =
      AwsError.unwrapOptionField("ipv6Pool", ipv6Pool)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getIpv4IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv4IpamPoolId", ipv4IpamPoolId)
    def getIpv4NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv4NetmaskLength", ipv4NetmaskLength)
    def getIpv6IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv6IpamPoolId", ipv6IpamPoolId)
    def getIpv6NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv6NetmaskLength", ipv6NetmaskLength)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getIpv6CidrBlockNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ipv6CidrBlockNetworkBorderGroup",
        ipv6CidrBlockNetworkBorderGroup
      )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ) extends zio.aws.ec2.model.CreateVpcRequest.ReadOnly {
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val amazonProvidedIpv6CidrBlock: Option[Boolean] = scala
      .Option(impl.amazonProvidedIpv6CidrBlock())
      .map(value => value: Boolean)
    override val ipv6Pool: Option[Ipv6PoolEc2Id] = scala
      .Option(impl.ipv6Pool())
      .map(value => zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(value))
    override val ipv6CidrBlock: Option[String] =
      scala.Option(impl.ipv6CidrBlock()).map(value => value: String)
    override val ipv4IpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipv4IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv4NetmaskLength: Option[NetmaskLength] = scala
      .Option(impl.ipv4NetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
    override val ipv6IpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipv6IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv6NetmaskLength: Option[NetmaskLength] = scala
      .Option(impl.ipv6NetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
    override val instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.instanceTenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val ipv6CidrBlockNetworkBorderGroup: Option[String] = scala
      .Option(impl.ipv6CidrBlockNetworkBorderGroup())
      .map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ): zio.aws.ec2.model.CreateVpcRequest.ReadOnly = new Wrapper(impl)
}
