package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsErrorItem(
    error: Option[zio.aws.ec2.model.CancelSpotFleetRequestsError] = None,
    spotFleetRequestId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem = {
    import CancelSpotFleetRequestsErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem =
      zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem(
        error.map(value => value.asEditable),
        spotFleetRequestId.map(value => value)
      )
    def error: Option[zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly]
    def spotFleetRequestId: Option[String]
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly {
    override val error
        : Option[zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly] =
      scala
        .Option(impl.error())
        .map(value =>
          zio.aws.ec2.model.CancelSpotFleetRequestsError.wrap(value)
        )
    override val spotFleetRequestId: Option[String] =
      scala.Option(impl.spotFleetRequestId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem
  ): zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly = new Wrapper(
    impl
  )
}
