package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeSecurityGroupEgressResponse(
    returnValue: Option[Boolean] = None,
    securityGroupRules: Option[Iterable[zio.aws.ec2.model.SecurityGroupRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse = {
    import AuthorizeSecurityGroupEgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(
        securityGroupRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupRules)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly =
    zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.wrap(buildAwsValue())
}
object AuthorizeSecurityGroupEgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse =
      zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse(
        returnValue.map(value => value),
        securityGroupRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def returnValue: Option[Boolean]
    def securityGroupRules
        : Option[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getSecurityGroupRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupRule.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroupRules", securityGroupRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse
  ) extends zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
    override val securityGroupRules
        : Option[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]] = scala
      .Option(impl.securityGroupRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SecurityGroupRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse
  ): zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly =
    new Wrapper(impl)
}
