package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{Port, IpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalysisLoadBalancerTarget(
    address: Option[IpAddress] = None,
    availabilityZone: Option[String] = None,
    instance: Option[zio.aws.ec2.model.AnalysisComponent] = None,
    port: Option[Port] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget = {
    import AnalysisLoadBalancerTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
      .builder()
      .optionallyWith(
        address.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly =
    zio.aws.ec2.model.AnalysisLoadBalancerTarget.wrap(buildAwsValue())
}
object AnalysisLoadBalancerTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisLoadBalancerTarget =
      zio.aws.ec2.model.AnalysisLoadBalancerTarget(
        address.map(value => value),
        availabilityZone.map(value => value),
        instance.map(value => value.asEditable),
        port.map(value => value)
      )
    def address: Option[IpAddress]
    def availabilityZone: Option[String]
    def instance: Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def port: Option[Port]
    def getAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("address", address)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstance
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("instance", instance)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ) extends zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly {
    override val address: Option[IpAddress] = scala
      .Option(impl.address())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val instance
        : Option[zio.aws.ec2.model.AnalysisComponent.ReadOnly] = scala
      .Option(impl.instance())
      .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ): zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly = new Wrapper(impl)
}
