package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnectionVpcInfo(
    cidrBlock: Option[String] = None,
    ipv6CidrBlockSet: Option[Iterable[zio.aws.ec2.model.Ipv6CidrBlock]] = None,
    cidrBlockSet: Option[Iterable[zio.aws.ec2.model.CidrBlock]] = None,
    ownerId: Option[String] = None,
    peeringOptions: Option[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription
    ] = None,
    vpcId: Option[String] = None,
    region: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo = {
    import VpcPeeringConnectionVpcInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockSet)
      .optionallyWith(
        cidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockSet)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(peeringOptions.map(value => value.buildAwsValue()))(
        _.peeringOptions
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly =
    zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.wrap(buildAwsValue())
}
object VpcPeeringConnectionVpcInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcPeeringConnectionVpcInfo =
      zio.aws.ec2.model.VpcPeeringConnectionVpcInfo(
        cidrBlock.map(value => value),
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        peeringOptions.map(value => value.asEditable),
        vpcId.map(value => value),
        region.map(value => value)
      )
    def cidrBlock: Option[String]
    def ipv6CidrBlockSet: Option[List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]]
    def cidrBlockSet: Option[List[zio.aws.ec2.model.CidrBlock.ReadOnly]]
    def ownerId: Option[String]
    def peeringOptions: Option[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ]
    def vpcId: Option[String]
    def region: Option[String]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getIpv6CidrBlockSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]] =
      AwsError.unwrapOptionField("ipv6CidrBlockSet", ipv6CidrBlockSet)
    def getCidrBlockSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CidrBlock.ReadOnly]] =
      AwsError.unwrapOptionField("cidrBlockSet", cidrBlockSet)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPeeringOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ] = AwsError.unwrapOptionField("peeringOptions", peeringOptions)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ) extends zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly {
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val ipv6CidrBlockSet
        : Option[List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]] = scala
      .Option(impl.ipv6CidrBlockSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6CidrBlock.wrap(item)
        }.toList
      )
    override val cidrBlockSet
        : Option[List[zio.aws.ec2.model.CidrBlock.ReadOnly]] = scala
      .Option(impl.cidrBlockSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CidrBlock.wrap(item)
        }.toList
      )
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val peeringOptions: Option[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ] = scala
      .Option(impl.peeringOptions())
      .map(value =>
        zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.wrap(value)
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ): zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly = new Wrapper(impl)
}
