package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VolumeAttachment(
    attachTime: Option[DateTime] = None,
    device: Option[String] = None,
    instanceId: Option[String] = None,
    state: Option[zio.aws.ec2.model.VolumeAttachmentState] = None,
    volumeId: Option[String] = None,
    deleteOnTermination: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeAttachment = {
    import VolumeAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeAttachment
      .builder()
      .optionallyWith(attachTime.map(value => DateTime.unwrap(value): Instant))(
        _.attachTime
      )
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeAttachment.ReadOnly =
    zio.aws.ec2.model.VolumeAttachment.wrap(buildAwsValue())
}
object VolumeAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeAttachment =
      zio.aws.ec2.model.VolumeAttachment(
        attachTime.map(value => value),
        device.map(value => value),
        instanceId.map(value => value),
        state.map(value => value),
        volumeId.map(value => value),
        deleteOnTermination.map(value => value)
      )
    def attachTime: Option[DateTime]
    def device: Option[String]
    def instanceId: Option[String]
    def state: Option[zio.aws.ec2.model.VolumeAttachmentState]
    def volumeId: Option[String]
    def deleteOnTermination: Option[Boolean]
    def getAttachTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeAttachment
  ) extends zio.aws.ec2.model.VolumeAttachment.ReadOnly {
    override val attachTime: Option[DateTime] = scala
      .Option(impl.attachTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val device: Option[String] =
      scala.Option(impl.device()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.VolumeAttachmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.VolumeAttachmentState.wrap(value))
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeAttachment
  ): zio.aws.ec2.model.VolumeAttachment.ReadOnly = new Wrapper(impl)
}
